/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class CompoundRule
extends AbstractCompoundRule {
    private static final CompoundRuleData compoundData = new CompoundRuleData("/en/compounds.txt");
    private static final Language AMERICAN_ENGLISH = new AmericanEnglish();
    private static List<DisambiguationPatternRule> antiDisambiguationPatterns = null;
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().tokenRegex("['\u00b4]").build(), new PatternTokenBuilder().token("re").build()));

    public CompoundRule(ResourceBundle messages) throws IOException {
        super(messages, "This word is normally spelled with hyphen.", "This word is normally spelled as one.", "This expression is normally spelled as one or with hyphen.", "Hyphenation problem");
        this.addExamplePair(Example.wrong("I now have a <marker>part time</marker> job."), Example.fixed("I now have a <marker>part-time</marker> job."));
    }

    @Override
    public String getId() {
        return "EN_COMPOUNDS";
    }

    @Override
    public String getDescription() {
        return "Hyphenated words, e.g., 'case-sensitive' instead of 'case sensitive'";
    }

    @Override
    protected CompoundRuleData getCompoundRuleData() {
        return compoundData;
    }

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        if (antiDisambiguationPatterns == null) {
            antiDisambiguationPatterns = this.makeAntiPatterns(ANTI_PATTERNS, AMERICAN_ENGLISH);
        }
        return antiDisambiguationPatterns;
    }
}

